# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIConnectedEnvironmentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_connected_environments_list_by_subscription(self, resource_group):
        response = self.client.connected_environments.list_by_subscription(
            api_version="2025-02-02-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_connected_environments_list_by_resource_group(self, resource_group):
        response = self.client.connected_environments.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-02-02-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_connected_environments_get(self, resource_group):
        response = self.client.connected_environments.get(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_connected_environments_begin_create_or_update(self, resource_group):
        response = self.client.connected_environments.begin_create_or_update(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            environment_envelope={
                "location": "str",
                "customDomainConfiguration": {
                    "certificateKeyVaultProperties": {"identity": "str", "keyVaultUrl": "str"},
                    "certificatePassword": "str",
                    "certificateValue": bytes("bytes", encoding="utf-8"),
                    "customDomainVerificationId": "str",
                    "dnsSuffix": "str",
                    "expirationDate": "2020-02-20 00:00:00",
                    "subjectName": "str",
                    "thumbprint": "str",
                },
                "daprAIConnectionString": "str",
                "defaultDomain": "str",
                "deploymentErrors": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "staticIp": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-02-02-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_connected_environments_begin_delete(self, resource_group):
        response = self.client.connected_environments.begin_delete(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            api_version="2025-02-02-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_connected_environments_update(self, resource_group):
        response = self.client.connected_environments.update(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_connected_environments_check_name_availability(self, resource_group):
        response = self.client.connected_environments.check_name_availability(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            check_name_availability_request={"name": "str", "type": "str"},
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...
