# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIManagedCertificatesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_certificates_get(self, resource_group):
        response = self.client.managed_certificates.get(
            resource_group_name=resource_group.name,
            environment_name="str",
            managed_certificate_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_certificates_begin_create_or_update(self, resource_group):
        response = self.client.managed_certificates.begin_create_or_update(
            resource_group_name=resource_group.name,
            environment_name="str",
            managed_certificate_name="str",
            api_version="2025-02-02-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_certificates_delete(self, resource_group):
        response = self.client.managed_certificates.delete(
            resource_group_name=resource_group.name,
            environment_name="str",
            managed_certificate_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_certificates_update(self, resource_group):
        response = self.client.managed_certificates.update(
            resource_group_name=resource_group.name,
            environment_name="str",
            managed_certificate_name="str",
            managed_certificate_envelope={"tags": {"str": "str"}},
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_certificates_list(self, resource_group):
        response = self.client.managed_certificates.list(
            resource_group_name=resource_group.name,
            environment_name="str",
            api_version="2025-02-02-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
