# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.settings import settings
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from . import models as _models
from ._configuration import ContainerServiceClientConfiguration
from ._utils.serialization import Deserializer, Serializer
from .operations import (
    AgentPoolsOperations,
    MachinesOperations,
    MaintenanceConfigurationsOperations,
    ManagedClustersOperations,
    Operations,
    PrivateEndpointConnectionsOperations,
    PrivateLinkResourcesOperations,
    ResolvePrivateLinkServiceIdOperations,
    SnapshotsOperations,
    TrustedAccessRoleBindingsOperations,
    TrustedAccessRolesOperations,
)

if TYPE_CHECKING:
    from azure.core import AzureClouds
    from azure.core.credentials import TokenCredential


class ContainerServiceClient:  # pylint: disable=too-many-instance-attributes
    """The Container Service Client.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.containerservice.operations.Operations
    :ivar managed_clusters: ManagedClustersOperations operations
    :vartype managed_clusters: azure.mgmt.containerservice.operations.ManagedClustersOperations
    :ivar maintenance_configurations: MaintenanceConfigurationsOperations operations
    :vartype maintenance_configurations:
     azure.mgmt.containerservice.operations.MaintenanceConfigurationsOperations
    :ivar agent_pools: AgentPoolsOperations operations
    :vartype agent_pools: azure.mgmt.containerservice.operations.AgentPoolsOperations
    :ivar private_endpoint_connections: PrivateEndpointConnectionsOperations operations
    :vartype private_endpoint_connections:
     azure.mgmt.containerservice.operations.PrivateEndpointConnectionsOperations
    :ivar private_link_resources: PrivateLinkResourcesOperations operations
    :vartype private_link_resources:
     azure.mgmt.containerservice.operations.PrivateLinkResourcesOperations
    :ivar resolve_private_link_service_id: ResolvePrivateLinkServiceIdOperations operations
    :vartype resolve_private_link_service_id:
     azure.mgmt.containerservice.operations.ResolvePrivateLinkServiceIdOperations
    :ivar snapshots: SnapshotsOperations operations
    :vartype snapshots: azure.mgmt.containerservice.operations.SnapshotsOperations
    :ivar trusted_access_role_bindings: TrustedAccessRoleBindingsOperations operations
    :vartype trusted_access_role_bindings:
     azure.mgmt.containerservice.operations.TrustedAccessRoleBindingsOperations
    :ivar trusted_access_roles: TrustedAccessRolesOperations operations
    :vartype trusted_access_roles:
     azure.mgmt.containerservice.operations.TrustedAccessRolesOperations
    :ivar machines: MachinesOperations operations
    :vartype machines: azure.mgmt.containerservice.operations.MachinesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword cloud_setting: The cloud setting for which to get the ARM endpoint. Default value is
     None.
    :paramtype cloud_setting: ~azure.core.AzureClouds
    :keyword api_version: Api Version. Default value is "2025-08-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        *,
        cloud_setting: Optional["AzureClouds"] = None,
        **kwargs: Any
    ) -> None:
        _cloud = cloud_setting or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = ContainerServiceClientConfiguration(
            credential=credential,
            subscription_id=subscription_id,
            cloud_setting=cloud_setting,
            credential_scopes=credential_scopes,
            **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=cast(str, base_url), policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.managed_clusters = ManagedClustersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.maintenance_configurations = MaintenanceConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.agent_pools = AgentPoolsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.resolve_private_link_service_id = ResolvePrivateLinkServiceIdOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.snapshots = SnapshotsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.trusted_access_role_bindings = TrustedAccessRoleBindingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.trusted_access_roles = TrustedAccessRolesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.machines = MachinesOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
