# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.netapp.aio import NetAppManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetAppManagementVolumeGroupsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetAppManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volume_groups_get(self, resource_group):
        response = await self.client.volume_groups.get(
            resource_group_name=resource_group.name,
            account_name="str",
            volume_group_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volume_groups_begin_create(self, resource_group):
        response = await (
            await self.client.volume_groups.begin_create(
                resource_group_name=resource_group.name,
                account_name="str",
                volume_group_name="str",
                body={
                    "id": "str",
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "groupMetaData": {
                            "applicationIdentifier": "str",
                            "applicationType": "str",
                            "globalPlacementRules": [{"key": "str", "value": "str"}],
                            "groupDescription": "str",
                            "volumesCount": 0,
                        },
                        "provisioningState": "str",
                        "volumes": [
                            {
                                "properties": {
                                    "creationToken": "str",
                                    "subnetId": "str",
                                    "usageThreshold": 0,
                                    "acceptGrowCapacityPoolForShortTermCloneSplit": "str",
                                    "actualThroughputMibps": 0.0,
                                    "avsDataStore": "str",
                                    "backupId": "str",
                                    "baremetalTenantId": "str",
                                    "capacityPoolResourceId": "str",
                                    "cloneProgress": 0,
                                    "coolAccess": bool,
                                    "coolAccessRetrievalPolicy": "str",
                                    "coolAccessTieringPolicy": "str",
                                    "coolnessPeriod": 0,
                                    "dataProtection": {
                                        "backup": {
                                            "backupPolicyId": "str",
                                            "backupVaultId": "str",
                                            "policyEnforced": bool,
                                        },
                                        "replication": {
                                            "destinationReplications": [
                                                {
                                                    "region": "str",
                                                    "replicationType": "str",
                                                    "resourceId": "str",
                                                    "zone": "str",
                                                }
                                            ],
                                            "endpointType": "str",
                                            "externalReplicationSetupInfo": "str",
                                            "externalReplicationSetupStatus": "str",
                                            "mirrorState": "str",
                                            "relationshipStatus": "str",
                                            "remotePath": {
                                                "externalHostName": "str",
                                                "serverName": "str",
                                                "volumeName": "str",
                                            },
                                            "remoteVolumeRegion": "str",
                                            "remoteVolumeResourceId": "str",
                                            "replicationId": "str",
                                            "replicationSchedule": "str",
                                        },
                                        "snapshot": {"snapshotPolicyId": "str"},
                                        "volumeRelocation": {"readyToBeFinalized": bool, "relocationRequested": bool},
                                    },
                                    "dataStoreResourceId": ["str"],
                                    "defaultGroupQuotaInKiBs": 0,
                                    "defaultUserQuotaInKiBs": 0,
                                    "deleteBaseSnapshot": bool,
                                    "effectiveNetworkFeatures": "str",
                                    "enableSubvolumes": "str",
                                    "encrypted": bool,
                                    "encryptionKeySource": "str",
                                    "exportPolicy": {
                                        "rules": [
                                            {
                                                "allowedClients": "str",
                                                "chownMode": "str",
                                                "cifs": bool,
                                                "hasRootAccess": bool,
                                                "kerberos5ReadOnly": bool,
                                                "kerberos5ReadWrite": bool,
                                                "kerberos5iReadOnly": bool,
                                                "kerberos5iReadWrite": bool,
                                                "kerberos5pReadOnly": bool,
                                                "kerberos5pReadWrite": bool,
                                                "nfsv3": bool,
                                                "nfsv41": bool,
                                                "ruleIndex": 0,
                                                "unixReadOnly": bool,
                                                "unixReadWrite": bool,
                                            }
                                        ]
                                    },
                                    "fileAccessLogs": "str",
                                    "fileSystemId": "str",
                                    "inheritedSizeInBytes": 0,
                                    "isDefaultQuotaEnabled": bool,
                                    "isLargeVolume": bool,
                                    "isRestoring": bool,
                                    "kerberosEnabled": bool,
                                    "keyVaultPrivateEndpointResourceId": "str",
                                    "language": "str",
                                    "ldapEnabled": bool,
                                    "ldapServerType": "str",
                                    "maximumNumberOfFiles": 0,
                                    "mountTargets": [
                                        {
                                            "fileSystemId": "str",
                                            "ipAddress": "str",
                                            "mountTargetId": "str",
                                            "smbServerFqdn": "str",
                                        }
                                    ],
                                    "networkFeatures": "str",
                                    "networkSiblingSetId": "str",
                                    "originatingResourceId": "str",
                                    "placementRules": [{"key": "str", "value": "str"}],
                                    "protocolTypes": ["str"],
                                    "provisionedAvailabilityZone": "str",
                                    "provisioningState": "str",
                                    "proximityPlacementGroup": "str",
                                    "securityStyle": "str",
                                    "serviceLevel": "str",
                                    "smbAccessBasedEnumeration": "str",
                                    "smbContinuouslyAvailable": bool,
                                    "smbEncryption": bool,
                                    "smbNonBrowsable": "str",
                                    "snapshotDirectoryVisible": bool,
                                    "snapshotId": "str",
                                    "storageToNetworkProximity": "str",
                                    "t2Network": "str",
                                    "throughputMibps": 0.0,
                                    "unixPermissions": "str",
                                    "volumeGroupName": "str",
                                    "volumeSpecName": "str",
                                    "volumeType": "str",
                                },
                                "id": "str",
                                "name": "str",
                                "tags": {"str": "str"},
                                "type": "str",
                                "zones": ["str"],
                            }
                        ],
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volume_groups_begin_delete(self, resource_group):
        response = await (
            await self.client.volume_groups.begin_delete(
                resource_group_name=resource_group.name,
                account_name="str",
                volume_group_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volume_groups_list_by_net_app_account(self, resource_group):
        response = self.client.volume_groups.list_by_net_app_account(
            resource_group_name=resource_group.name,
            account_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
