# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.9.5, generator: @autorest/python@6.39.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Optional, TYPE_CHECKING, MutableMapping

from .._utils import serialization as _serialization

JSON = MutableMapping[str, Any]

if TYPE_CHECKING:
    from .. import models as _models


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.search.documents.agent.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.search.documents.agent.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.ErrorDetail"]] = None
        self.additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.search.documents.agent.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.search.documents.agent.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class KnowledgeAgentActivityRecord(_serialization.Model):
    """Base type for activity records.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeAgentRetrievalActivityRecord, KnowledgeAgentModelAnswerSynthesisActivityRecord,
    KnowledgeAgentModelQueryPlanningActivityRecord, KnowledgeAgentSemanticRerankerActivityRecord

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
    }

    _subtype_map = {
        "type": {
            "KnowledgeAgentRetrievalActivityRecord": "KnowledgeAgentRetrievalActivityRecord",
            "modelAnswerSynthesis": "KnowledgeAgentModelAnswerSynthesisActivityRecord",
            "modelQueryPlanning": "KnowledgeAgentModelQueryPlanningActivityRecord",
            "semanticReranker": "KnowledgeAgentSemanticRerankerActivityRecord",
        }
    }

    def __init__(
        self, *, id: int, elapsed_ms: Optional[int] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.type: Optional[str] = None
        self.elapsed_ms = elapsed_ms


class KnowledgeAgentAzureBlobActivityArguments(_serialization.Model):
    """Represents the arguments the azure blob retrieval activity was run with.

    :ivar search: The search string used to query blob contents.
    :vartype search: str
    """

    _attribute_map = {
        "search": {"key": "search", "type": "str"},
    }

    def __init__(self, *, search: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword search: The search string used to query blob contents.
        :paramtype search: str
        """
        super().__init__(**kwargs)
        self.search = search


class KnowledgeAgentRetrievalActivityRecord(KnowledgeAgentActivityRecord):
    """Represents a retrieval activity record.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeAgentAzureBlobActivityRecord, KnowledgeAgentSearchIndexActivityRecord

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar knowledge_source_name: The knowledge source for the retrieval activity.
    :vartype knowledge_source_name: str
    :ivar query_time: The query time for this retrieval activity.
    :vartype query_time: ~datetime.datetime
    :ivar count: The count of documents retrieved that were sufficiently relevant to pass the
     reranker threshold.
    :vartype count: int
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "count": {"key": "count", "type": "int"},
    }

    _subtype_map = {
        "type": {
            "azureBlob": "KnowledgeAgentAzureBlobActivityRecord",
            "searchIndex": "KnowledgeAgentSearchIndexActivityRecord",
        }
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        knowledge_source_name: Optional[str] = None,
        query_time: Optional[datetime.datetime] = None,
        count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword knowledge_source_name: The knowledge source for the retrieval activity.
        :paramtype knowledge_source_name: str
        :keyword query_time: The query time for this retrieval activity.
        :paramtype query_time: ~datetime.datetime
        :keyword count: The count of documents retrieved that were sufficiently relevant to pass the
         reranker threshold.
        :paramtype count: int
        """
        super().__init__(id=id, elapsed_ms=elapsed_ms, **kwargs)
        self.type: str = "KnowledgeAgentRetrievalActivityRecord"
        self.knowledge_source_name = knowledge_source_name
        self.query_time = query_time
        self.count = count


class KnowledgeAgentAzureBlobActivityRecord(KnowledgeAgentRetrievalActivityRecord):
    """Represents a azure blob retrieval activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar knowledge_source_name: The knowledge source for the retrieval activity.
    :vartype knowledge_source_name: str
    :ivar query_time: The query time for this retrieval activity.
    :vartype query_time: ~datetime.datetime
    :ivar count: The count of documents retrieved that were sufficiently relevant to pass the
     reranker threshold.
    :vartype count: int
    :ivar azure_blob_arguments: The azure blob arguments for the retrieval activity.
    :vartype azure_blob_arguments:
     ~azure.search.documents.agent.models.KnowledgeAgentAzureBlobActivityArguments
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "count": {"key": "count", "type": "int"},
        "azure_blob_arguments": {"key": "azureBlobArguments", "type": "KnowledgeAgentAzureBlobActivityArguments"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        knowledge_source_name: Optional[str] = None,
        query_time: Optional[datetime.datetime] = None,
        count: Optional[int] = None,
        azure_blob_arguments: Optional["_models.KnowledgeAgentAzureBlobActivityArguments"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword knowledge_source_name: The knowledge source for the retrieval activity.
        :paramtype knowledge_source_name: str
        :keyword query_time: The query time for this retrieval activity.
        :paramtype query_time: ~datetime.datetime
        :keyword count: The count of documents retrieved that were sufficiently relevant to pass the
         reranker threshold.
        :paramtype count: int
        :keyword azure_blob_arguments: The azure blob arguments for the retrieval activity.
        :paramtype azure_blob_arguments:
         ~azure.search.documents.agent.models.KnowledgeAgentAzureBlobActivityArguments
        """
        super().__init__(
            id=id,
            elapsed_ms=elapsed_ms,
            knowledge_source_name=knowledge_source_name,
            query_time=query_time,
            count=count,
            **kwargs
        )
        self.type: str = "azureBlob"
        self.azure_blob_arguments = azure_blob_arguments


class KnowledgeAgentReference(_serialization.Model):
    """Base type for references.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeAgentAzureBlobReference, KnowledgeAgentSearchIndexReference

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: Dictionary of :code:`<any>`.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
        "source_data": {"key": "sourceData", "type": "{object}"},
        "reranker_score": {"key": "rerankerScore", "type": "float"},
    }

    _subtype_map = {
        "type": {"azureBlob": "KnowledgeAgentAzureBlobReference", "searchIndex": "KnowledgeAgentSearchIndexReference"}
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        :keyword source_data: Dictionary of :code:`<any>`.
        :paramtype source_data: dict[str, any]
        :keyword reranker_score: The reranker score for the document reference.
        :paramtype reranker_score: float
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.id = id
        self.activity_source = activity_source
        self.source_data = source_data
        self.reranker_score = reranker_score


class KnowledgeAgentAzureBlobReference(KnowledgeAgentReference):
    """Represents an Azure Blob Storage document reference.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: Dictionary of :code:`<any>`.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar blob_url: The blob URL for the reference.
    :vartype blob_url: str
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
        "source_data": {"key": "sourceData", "type": "{object}"},
        "reranker_score": {"key": "rerankerScore", "type": "float"},
        "blob_url": {"key": "blobUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        blob_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        :keyword source_data: Dictionary of :code:`<any>`.
        :paramtype source_data: dict[str, any]
        :keyword reranker_score: The reranker score for the document reference.
        :paramtype reranker_score: float
        :keyword blob_url: The blob URL for the reference.
        :paramtype blob_url: str
        """
        super().__init__(
            id=id, activity_source=activity_source, source_data=source_data, reranker_score=reranker_score, **kwargs
        )
        self.type: str = "azureBlob"
        self.blob_url = blob_url


class KnowledgeAgentMessage(_serialization.Model):
    """The natural language message style object.

    All required parameters must be populated in order to send to server.

    :ivar role: The role of the tool response.
    :vartype role: str
    :ivar content: Required.
    :vartype content: list[~azure.search.documents.agent.models.KnowledgeAgentMessageContent]
    """

    _validation = {
        "content": {"required": True},
    }

    _attribute_map = {
        "role": {"key": "role", "type": "str"},
        "content": {"key": "content", "type": "[KnowledgeAgentMessageContent]"},
    }

    def __init__(
        self, *, content: list["_models.KnowledgeAgentMessageContent"], role: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword role: The role of the tool response.
        :paramtype role: str
        :keyword content: Required.
        :paramtype content: list[~azure.search.documents.agent.models.KnowledgeAgentMessageContent]
        """
        super().__init__(**kwargs)
        self.role = role
        self.content = content


class KnowledgeAgentMessageContent(_serialization.Model):
    """Specifies the type of the message content.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeAgentMessageImageContent, KnowledgeAgentMessageTextContent

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the message. Required. Known values are: "text" and "image".
    :vartype type: str or ~azure.search.documents.agent.models.KnowledgeAgentMessageContentType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"image": "KnowledgeAgentMessageImageContent", "text": "KnowledgeAgentMessageTextContent"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class KnowledgeAgentMessageImageContent(KnowledgeAgentMessageContent):
    """Text message type.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the message. Required. Known values are: "text" and "image".
    :vartype type: str or ~azure.search.documents.agent.models.KnowledgeAgentMessageContentType
    :ivar image: Required.
    :vartype image: ~azure.search.documents.agent.models.KnowledgeAgentMessageImageContentImage
    """

    _validation = {
        "type": {"required": True},
        "image": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "image": {"key": "image", "type": "KnowledgeAgentMessageImageContentImage"},
    }

    def __init__(self, *, image: "_models.KnowledgeAgentMessageImageContentImage", **kwargs: Any) -> None:
        """
        :keyword image: Required.
        :paramtype image: ~azure.search.documents.agent.models.KnowledgeAgentMessageImageContentImage
        """
        super().__init__(**kwargs)
        self.type: str = "image"
        self.image = image


class KnowledgeAgentMessageImageContentImage(_serialization.Model):
    """KnowledgeAgentMessageImageContentImage.

    All required parameters must be populated in order to send to server.

    :ivar url: The url of the image. Required.
    :vartype url: str
    """

    _validation = {
        "url": {"required": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: str, **kwargs: Any) -> None:
        """
        :keyword url: The url of the image. Required.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.url = url


class KnowledgeAgentMessageTextContent(KnowledgeAgentMessageContent):
    """Text message type.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the message. Required. Known values are: "text" and "image".
    :vartype type: str or ~azure.search.documents.agent.models.KnowledgeAgentMessageContentType
    :ivar text: Required.
    :vartype text: str
    """

    _validation = {
        "type": {"required": True},
        "text": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "text": {"key": "text", "type": "str"},
    }

    def __init__(self, *, text: str, **kwargs: Any) -> None:
        """
        :keyword text: Required.
        :paramtype text: str
        """
        super().__init__(**kwargs)
        self.type: str = "text"
        self.text = text


class KnowledgeAgentModelAnswerSynthesisActivityRecord(KnowledgeAgentActivityRecord):  # pylint: disable=name-too-long
    """Represents an LLM answer synthesis activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar input_tokens: The number of input tokens for the LLM answer synthesis activity.
    :vartype input_tokens: int
    :ivar output_tokens: The number of output tokens for the LLM answer synthesis activity.
    :vartype output_tokens: int
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "input_tokens": {"key": "inputTokens", "type": "int"},
        "output_tokens": {"key": "outputTokens", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        input_tokens: Optional[int] = None,
        output_tokens: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword input_tokens: The number of input tokens for the LLM answer synthesis activity.
        :paramtype input_tokens: int
        :keyword output_tokens: The number of output tokens for the LLM answer synthesis activity.
        :paramtype output_tokens: int
        """
        super().__init__(id=id, elapsed_ms=elapsed_ms, **kwargs)
        self.type: str = "modelAnswerSynthesis"
        self.input_tokens = input_tokens
        self.output_tokens = output_tokens


class KnowledgeAgentModelQueryPlanningActivityRecord(KnowledgeAgentActivityRecord):  # pylint: disable=name-too-long
    """Represents an LLM query planning activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar input_tokens: The number of input tokens for the LLM query planning activity.
    :vartype input_tokens: int
    :ivar output_tokens: The number of output tokens for the LLM query planning activity.
    :vartype output_tokens: int
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "input_tokens": {"key": "inputTokens", "type": "int"},
        "output_tokens": {"key": "outputTokens", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        input_tokens: Optional[int] = None,
        output_tokens: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword input_tokens: The number of input tokens for the LLM query planning activity.
        :paramtype input_tokens: int
        :keyword output_tokens: The number of output tokens for the LLM query planning activity.
        :paramtype output_tokens: int
        """
        super().__init__(id=id, elapsed_ms=elapsed_ms, **kwargs)
        self.type: str = "modelQueryPlanning"
        self.input_tokens = input_tokens
        self.output_tokens = output_tokens


class KnowledgeAgentRetrievalRequest(_serialization.Model):
    """The input contract for the retrieval request.

    All required parameters must be populated in order to send to server.

    :ivar messages: Required.
    :vartype messages: list[~azure.search.documents.agent.models.KnowledgeAgentMessage]
    :ivar knowledge_source_params:
    :vartype knowledge_source_params:
     list[~azure.search.documents.agent.models.KnowledgeSourceParams]
    """

    _validation = {
        "messages": {"required": True},
    }

    _attribute_map = {
        "messages": {"key": "messages", "type": "[KnowledgeAgentMessage]"},
        "knowledge_source_params": {"key": "knowledgeSourceParams", "type": "[KnowledgeSourceParams]"},
    }

    def __init__(
        self,
        *,
        messages: list["_models.KnowledgeAgentMessage"],
        knowledge_source_params: Optional[list["_models.KnowledgeSourceParams"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword messages: Required.
        :paramtype messages: list[~azure.search.documents.agent.models.KnowledgeAgentMessage]
        :keyword knowledge_source_params:
        :paramtype knowledge_source_params:
         list[~azure.search.documents.agent.models.KnowledgeSourceParams]
        """
        super().__init__(**kwargs)
        self.messages = messages
        self.knowledge_source_params = knowledge_source_params


class KnowledgeAgentRetrievalResponse(_serialization.Model):
    """The output contract for the retrieval response.

    :ivar response:
    :vartype response: list[~azure.search.documents.agent.models.KnowledgeAgentMessage]
    :ivar activity: The activity records for tracking progress and billing implications.
    :vartype activity: list[~azure.search.documents.agent.models.KnowledgeAgentActivityRecord]
    :ivar references: The references for the retrieval data used in the response.
    :vartype references: list[~azure.search.documents.agent.models.KnowledgeAgentReference]
    """

    _attribute_map = {
        "response": {"key": "response", "type": "[KnowledgeAgentMessage]"},
        "activity": {"key": "activity", "type": "[KnowledgeAgentActivityRecord]"},
        "references": {"key": "references", "type": "[KnowledgeAgentReference]"},
    }

    def __init__(
        self,
        *,
        response: Optional[list["_models.KnowledgeAgentMessage"]] = None,
        activity: Optional[list["_models.KnowledgeAgentActivityRecord"]] = None,
        references: Optional[list["_models.KnowledgeAgentReference"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword response:
        :paramtype response: list[~azure.search.documents.agent.models.KnowledgeAgentMessage]
        :keyword activity: The activity records for tracking progress and billing implications.
        :paramtype activity: list[~azure.search.documents.agent.models.KnowledgeAgentActivityRecord]
        :keyword references: The references for the retrieval data used in the response.
        :paramtype references: list[~azure.search.documents.agent.models.KnowledgeAgentReference]
        """
        super().__init__(**kwargs)
        self.response = response
        self.activity = activity
        self.references = references


class KnowledgeAgentSearchIndexActivityArguments(_serialization.Model):  # pylint: disable=name-too-long
    """Represents the arguments the search index retrieval activity was run with.

    :ivar search: The search string used to query the search index.
    :vartype search: str
    :ivar filter: The filter string.
    :vartype filter: str
    """

    _attribute_map = {
        "search": {"key": "search", "type": "str"},
        "filter": {"key": "filter", "type": "str"},
    }

    def __init__(
        self,
        *,
        search: Optional[str] = None,
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword search: The search string used to query the search index.
        :paramtype search: str
        :keyword filter: The filter string.
        :paramtype filter: str
        """
        super().__init__(**kwargs)
        self.search = search
        self.filter = filter


class KnowledgeAgentSearchIndexActivityRecord(KnowledgeAgentRetrievalActivityRecord):
    """Represents a search index retrieval activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar knowledge_source_name: The knowledge source for the retrieval activity.
    :vartype knowledge_source_name: str
    :ivar query_time: The query time for this retrieval activity.
    :vartype query_time: ~datetime.datetime
    :ivar count: The count of documents retrieved that were sufficiently relevant to pass the
     reranker threshold.
    :vartype count: int
    :ivar search_index_arguments: The search index arguments for the retrieval activity.
    :vartype search_index_arguments:
     ~azure.search.documents.agent.models.KnowledgeAgentSearchIndexActivityArguments
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "count": {"key": "count", "type": "int"},
        "search_index_arguments": {"key": "searchIndexArguments", "type": "KnowledgeAgentSearchIndexActivityArguments"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        knowledge_source_name: Optional[str] = None,
        query_time: Optional[datetime.datetime] = None,
        count: Optional[int] = None,
        search_index_arguments: Optional["_models.KnowledgeAgentSearchIndexActivityArguments"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword knowledge_source_name: The knowledge source for the retrieval activity.
        :paramtype knowledge_source_name: str
        :keyword query_time: The query time for this retrieval activity.
        :paramtype query_time: ~datetime.datetime
        :keyword count: The count of documents retrieved that were sufficiently relevant to pass the
         reranker threshold.
        :paramtype count: int
        :keyword search_index_arguments: The search index arguments for the retrieval activity.
        :paramtype search_index_arguments:
         ~azure.search.documents.agent.models.KnowledgeAgentSearchIndexActivityArguments
        """
        super().__init__(
            id=id,
            elapsed_ms=elapsed_ms,
            knowledge_source_name=knowledge_source_name,
            query_time=query_time,
            count=count,
            **kwargs
        )
        self.type: str = "searchIndex"
        self.search_index_arguments = search_index_arguments


class KnowledgeAgentSearchIndexReference(KnowledgeAgentReference):
    """Represents an Azure Search document reference.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: Dictionary of :code:`<any>`.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar doc_key: The document key for the reference.
    :vartype doc_key: str
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
        "source_data": {"key": "sourceData", "type": "{object}"},
        "reranker_score": {"key": "rerankerScore", "type": "float"},
        "doc_key": {"key": "docKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        doc_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        :keyword source_data: Dictionary of :code:`<any>`.
        :paramtype source_data: dict[str, any]
        :keyword reranker_score: The reranker score for the document reference.
        :paramtype reranker_score: float
        :keyword doc_key: The document key for the reference.
        :paramtype doc_key: str
        """
        super().__init__(
            id=id, activity_source=activity_source, source_data=source_data, reranker_score=reranker_score, **kwargs
        )
        self.type: str = "searchIndex"
        self.doc_key = doc_key


class KnowledgeAgentSemanticRerankerActivityRecord(KnowledgeAgentActivityRecord):  # pylint: disable=name-too-long
    """Represents a semantic ranker activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar input_tokens: The number of input tokens for the semantic ranker activity.
    :vartype input_tokens: int
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "input_tokens": {"key": "inputTokens", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        input_tokens: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword input_tokens: The number of input tokens for the semantic ranker activity.
        :paramtype input_tokens: int
        """
        super().__init__(id=id, elapsed_ms=elapsed_ms, **kwargs)
        self.type: str = "semanticReranker"
        self.input_tokens = input_tokens


class KnowledgeSourceParams(_serialization.Model):
    """KnowledgeSourceParams.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SearchIndexKnowledgeSourceParams

    All required parameters must be populated in order to send to server.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar kind: The type of the knowledge source. Required. Known values are: "searchIndex" and
     "azureBlob".
    :vartype kind: str or ~azure.search.documents.agent.models.KnowledgeSourceKind
    """

    _validation = {
        "knowledge_source_name": {"required": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"searchIndex": "SearchIndexKnowledgeSourceParams"}}

    def __init__(self, *, knowledge_source_name: str, **kwargs: Any) -> None:
        """
        :keyword knowledge_source_name: The name of the index the params apply to. Required.
        :paramtype knowledge_source_name: str
        """
        super().__init__(**kwargs)
        self.knowledge_source_name = knowledge_source_name
        self.kind: Optional[str] = None


class RequestOptions(_serialization.Model):
    """Parameter group.

    :ivar x_ms_client_request_id: The tracking ID sent with the request to help with debugging.
    :vartype x_ms_client_request_id: str
    """

    _attribute_map = {
        "x_ms_client_request_id": {"key": "x-ms-client-request-id", "type": "str"},
    }

    def __init__(self, *, x_ms_client_request_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword x_ms_client_request_id: The tracking ID sent with the request to help with debugging.
        :paramtype x_ms_client_request_id: str
        """
        super().__init__(**kwargs)
        self.x_ms_client_request_id = x_ms_client_request_id


class SearchIndexKnowledgeSourceParams(KnowledgeSourceParams):
    """Specifies runtime parameters for a search index knowledge source.

    All required parameters must be populated in order to send to server.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar kind: The type of the knowledge source. Required. Known values are: "searchIndex" and
     "azureBlob".
    :vartype kind: str or ~azure.search.documents.agent.models.KnowledgeSourceKind
    :ivar filter_add_on: A filter condition applied to the index (e.g., 'State eq VA').
    :vartype filter_add_on: str
    """

    _validation = {
        "knowledge_source_name": {"required": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "filter_add_on": {"key": "filterAddOn", "type": "str"},
    }

    def __init__(self, *, knowledge_source_name: str, filter_add_on: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword knowledge_source_name: The name of the index the params apply to. Required.
        :paramtype knowledge_source_name: str
        :keyword filter_add_on: A filter condition applied to the index (e.g., 'State eq VA').
        :paramtype filter_add_on: str
        """
        super().__init__(knowledge_source_name=knowledge_source_name, **kwargs)
        self.kind: str = "searchIndex"
        self.filter_add_on = filter_add_on
