A `#[coverage(off|on)]` attribute was found in a position where it is not
allowed.

Coverage attributes can be applied to:
- Function and method declarations that have a body, including trait methods
  that have a default implementation.
- Closure expressions, in situations where attributes can be applied to
  expressions.
- `impl` blocks (inherent or trait), and modules.

Example of erroneous code:

```compile_fail,E0788
unsafe extern "C" {
    #[coverage(off)]
    fn foreign_fn();
}
```

When using the `-C instrument-coverage` flag, coverage attributes act as a
hint to the compiler that it should instrument or not instrument the
corresponding function or enclosed functions. The precise effect of applying
a coverage attribute is not guaranteed and may change in future compiler
versions.
